{========================================================================}
{=                (c) 1995-98 SwiftSoft Ronald Dittrich                 =}
{========================================================================}
{=                          All Rights Reserved                         =}
{========================================================================}
{=  D 01099 Dresden             = Fax.: +49(0)351-8037944               =}
{=  Loewenstr.7a                = info@swiftsoft.de                     =}
{========================================================================}
{=  Actual versions on http://www.swiftsoft.de/index.html               =}
{========================================================================}
{=  This code is for reference purposes only and may not be copied or   =}
{=  distributed in any format electronic or otherwise except one copy   =}
{=  for backup purposes.                                                =}
{=                                                                      =}
{=  No Delphi Component Kit or Component individually or in a collection=}
{=  subclassed or otherwise from the code in this unit, or associated   =}
{=  .pas, .dfm, .dcu, .asm or .obj files may be sold or distributed     =}
{=  without express permission from SwiftSoft.                          =}
{=                                                                      =}
{=  For more licence informations please refer to the associated        =}
{=  HelpFile.                                                           =}
{========================================================================}
{=  $Date: 07.11.98 - 19:34:20 $                                        =}
{========================================================================}
unit Unit1;

interface

uses
    Windows,
    Messages,
    SysUtils,
    Classes,
    Graphics,
    Controls,
    Forms,
    Dialogs,
    Menus,
    ExtCtrls,
    StdCtrls,
    ComCtrls,
    MMObj,
    MMAbout,
    MMHTimer,
    MMDSMix,
    MMWave,
    MMCstDlg,
    MMDSPObj;

const
    MaxWaves = 8;

type
   TWavePanel = record
      Name     : TLabel;
      Muting   : TCheckBox;
      Looping  : TCheckBox;
      Position : TProgressBar;
      Volume   : TTrackBar;
      Frequency: TTrackBar;
      Panning  : TTrackBar;
   end;

type
  TMainForm = class(TForm)
    MainMenu1: TMainMenu;
    MMWaveMixer: TMMDSWaveMixer;
    File1: TMenuItem;
    Open1: TMenuItem;
    N1: TMenuItem;
    Exit1: TMenuItem;
    Bevel1: TBevel;
    MMHiTimer: TMMHiTimer;
    MMMemoryWave: TMMMemoryWave;
    MMWaveOpenDialog: TMMWaveOpenDialog;
    Panel6: TPanel;
    Bevel10: TBevel;
    Label3: TLabel;
    Label1: TLabel;
    Label2: TLabel;
    Bevel11: TBevel;
    lblName6: TLabel;
    trackVolume6: TTrackBar;
    trackFrequency6: TTrackBar;
    ckBLoop6: TCheckBox;
    btnStop6: TButton;
    btnPlay6: TButton;
    trackPanning6: TTrackBar;
    btnClose6: TButton;
    barPosition6: TProgressBar;
    Label4: TLabel;
    Panel5: TPanel;
    Bevel2: TBevel;
    Label5: TLabel;
    Label6: TLabel;
    Label7: TLabel;
    Bevel3: TBevel;
    lblName5: TLabel;
    Label9: TLabel;
    trackVolume5: TTrackBar;
    trackFrequency5: TTrackBar;
    ckBLoop5: TCheckBox;
    btnStop5: TButton;
    btnPlay5: TButton;
    trackPanning5: TTrackBar;
    btnClose5: TButton;
    barPosition5: TProgressBar;
    Panel4: TPanel;
    Bevel4: TBevel;
    Label10: TLabel;
    Label11: TLabel;
    Label12: TLabel;
    Bevel5: TBevel;
    lblName4: TLabel;
    Label14: TLabel;
    trackVolume4: TTrackBar;
    trackFrequency4: TTrackBar;
    ckBLoop4: TCheckBox;
    btnStop4: TButton;
    btnPlay4: TButton;
    trackPanning4: TTrackBar;
    btnClose4: TButton;
    barPosition4: TProgressBar;
    Panel3: TPanel;
    Bevel6: TBevel;
    Label15: TLabel;
    Label16: TLabel;
    Label17: TLabel;
    Bevel7: TBevel;
    lblName3: TLabel;
    Label19: TLabel;
    trackVolume3: TTrackBar;
    trackFrequency3: TTrackBar;
    ckBLoop3: TCheckBox;
    btnStop3: TButton;
    btnPlay3: TButton;
    trackPanning3: TTrackBar;
    btnClose3: TButton;
    barPosition3: TProgressBar;
    Panel2: TPanel;
    Bevel8: TBevel;
    Label20: TLabel;
    Label21: TLabel;
    Label22: TLabel;
    Bevel9: TBevel;
    lblName2: TLabel;
    Label24: TLabel;
    trackVolume2: TTrackBar;
    trackFrequency2: TTrackBar;
    ckBLoop2: TCheckBox;
    btnStop2: TButton;
    btnPlay2: TButton;
    trackPanning2: TTrackBar;
    btnClose2: TButton;
    barPosition2: TProgressBar;
    Panel1: TPanel;
    Bevel12: TBevel;
    Label25: TLabel;
    Label26: TLabel;
    Label27: TLabel;
    Bevel13: TBevel;
    lblName1: TLabel;
    Label29: TLabel;
    trackVolume1: TTrackBar;
    trackFrequency1: TTrackBar;
    ckBLoop1: TCheckBox;
    btnStop1: TButton;
    btnPlay1: TButton;
    trackPanning1: TTrackBar;
    btnClose1: TButton;
    barPosition1: TProgressBar;
    About: TMenuItem;
    Panel7: TPanel;
    Bevel14: TBevel;
    Label8: TLabel;
    Label13: TLabel;
    Label18: TLabel;
    Bevel15: TBevel;
    lblName7: TLabel;
    Label28: TLabel;
    trackVolume7: TTrackBar;
    trackFrequency7: TTrackBar;
    ckBLoop7: TCheckBox;
    btnStop7: TButton;
    btnPlay7: TButton;
    trackPanning7: TTrackBar;
    btnClose7: TButton;
    barPosition7: TProgressBar;
    Panel8: TPanel;
    Bevel16: TBevel;
    Label30: TLabel;
    Label31: TLabel;
    Label32: TLabel;
    Bevel17: TBevel;
    lblName8: TLabel;
    Label34: TLabel;
    trackVolume8: TTrackBar;
    trackFrequency8: TTrackBar;
    ckBLoop8: TCheckBox;
    btnStop8: TButton;
    btnPlay8: TButton;
    trackPanning8: TTrackBar;
    btnClose8: TButton;
    barPosition8: TProgressBar;
    btnPause1: TButton;
    btnPause2: TButton;
    btnPause3: TButton;
    btnPause4: TButton;
    btnPause5: TButton;
    btnPause6: TButton;
    btnPause7: TButton;
    btnPause8: TButton;
    ckBMute1: TCheckBox;
    ckBMute2: TCheckBox;
    ckBMute3: TCheckBox;
    ckBMute4: TCheckBox;
    ckBMute5: TCheckBox;
    ckBMute6: TCheckBox;
    ckBMute7: TCheckBox;
    ckBMute8: TCheckBox;
    btnDuplicate1: TButton;
    btnDuplicate2: TButton;
    btnDuplicate3: TButton;
    btnDuplicate4: TButton;
    btnDuplicate5: TButton;
    btnDuplicate6: TButton;
    btnDuplicate7: TButton;
    btnDuplicate8: TButton;
    Options1: TMenuItem;
    procedure ckBLoopClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure OpenClick(Sender: TObject);
    procedure Exit1Click(Sender: TObject);
    procedure btnPlayClick(Sender: TObject);
    procedure btnStopClick(Sender: TObject);
    procedure btnDuplicateClick(Sender: TObject);
    procedure btnCloseClick(Sender: TObject);
    procedure trackVolumeChange(Sender: TObject);
    procedure trackFrequencyChange(Sender: TObject);
    procedure trackPanningChange(Sender: TObject);
    procedure MMHiTimerTimer(Sender: TObject);
    procedure AboutClick(Sender: TObject);
    procedure btnPauseClick(Sender: TObject);
    procedure ckBMuteClick(Sender: TObject);
    procedure btnExitClick(Sender: TObject);
    procedure OptionsClick(Sender: TObject);
  private
    procedure WMGetMinMaxInfo(Var Msg: TWMGetMinMaxInfo); message WM_GETMINMAXINFO;
    procedure WMInitMenuPopup(Var Msg: TWMInitMenuPopup); message WM_INITMENUPOPUP;
    procedure WMNCHitTest(Var Msg: TWMNCHitTest); message WM_NCHitTest;
  public
    NumWaves: integer;
    WavePanels: array[1..MaxWaves] of TWavePanel;
  end;

var
  MainForm: TMainForm;

implementation

uses Unit2;

{$R *.DFM}

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.WMGetMinMaxInfo(Var Msg: TWMGetMinMaxInfo);
begin
   with Msg.MinMaxInfo^ do
   begin
      ptMinTrackSize.X := Width;                       { Minimum width  }
      ptMinTrackSize.Y := Height;                      { Minimum height }
      ptMaxTrackSize.X := Width;                       { Maximum width  }
      ptMaxTrackSize.Y := Height;                      { Maximum height }
   end;
   Msg.Result := 0;          { Tell windows you have changed minmaxinfo }
   inherited;
end;

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.WMInitMenuPopup(Var Msg: TWMInitMenuPopup);
begin
   inherited;
   if Msg.SystemMenu then
      EnableMenuItem(Msg.MenuPopup, SC_SIZE, MF_BYCOMMAND or MF_GRAYED);
end;

{-- TMainForm ------------------------------------------------------------}
procedure TMainForm.WMNCHitTest(Var Msg: TWMNCHitTest);
begin
   inherited;
   with Msg do
     if Result in [HTLEFT, HTRIGHT, HTBOTTOM, HTBOTTOMRIGHT,
                   HTBOTTOMLEFT, HTTOP, HTTOPRIGHT, HTTOPLEFT] then
        Result:= Windows.HTNOWHERE;
end;

{-- TMainForm -----------------------------------------------------------}
procedure TMainForm.FormCreate(Sender: TObject);
var
   i: integer;

begin
   MMWaveMixer.Open;
   NumWaves := 0;
   for i := 1 to MaxWaves do
   begin
      WavePanels[i].Name := TLabel(FindComponent('lblName'+IntToStr(i)));
      WavePanels[i].Looping := TCheckBox(FindComponent('ckBLoop'+IntToStr(i)));
      WavePanels[i].Muting := TCheckBox(FindComponent('ckBMute'+IntToStr(i)));
      WavePanels[i].Position := TProgressBar(FindComponent('barPosition'+IntToStr(i)));
      WavePanels[i].Volume := TTrackBar(FindComponent('trackVolume'+IntToStr(i)));
      WavePanels[i].Frequency := TTrackBar(FindComponent('trackFrequency'+IntToStr(i)));
      WavePanels[i].Panning := TTrackBar(FindComponent('trackPanning'+IntToStr(i)));
   end;
   MMHiTimer.Enabled := True;
end;

{-- TMainForm -----------------------------------------------------------}
procedure TMainForm.FormClose(Sender: TObject; var Action: TCloseAction);
begin
   MMHiTimer.Enabled := False;
   MMWaveMixer.Close;
end;

{-- TMainForm -----------------------------------------------------------}
procedure TMainForm.Exit1Click(Sender: TObject);
begin
   Close;
end;

{-- TMainForm -----------------------------------------------------------}
procedure TMainForm.AboutClick(Sender: TObject);
begin
   Show_AboutBox(0);
end;

{-- TMainForm -----------------------------------------------------------}
procedure TMainForm.OpenClick(Sender: TObject);
var
   i: integer;
   aName: string;

begin
   if MMWaveOpenDialog.Execute then
   begin
      aName := ExtractFileName(MMWaveOpenDialog.FileName);
      aName := Copy(aName, 1, Pos('.', aName )-1);

      MMMemoryWave.LoadFromFile(MMWaveOpenDialog.FileName);
      MMWaveMixer.AddBuffer(aName, MMMemoryWave.Wave);

      for i := 0 to ComponentCount-1 do
      begin
         if (Components[i] is TPanel) then
         with TPanel(Components[i]) do
         begin
            if not Visible then
            with WavePanels[Tag] do
            begin
               Name.Caption := aName;
               Looping.Checked := False;
               Volume.Position := (MMWaveMixer.BufferByName[aName].Volume div 10)+400;
               Frequency.Position := MMWaveMixer.BufferByName[aName].Frequency;
               Panning.Position := (MMWaveMixer.BufferByName[aName].Panning div 10)+400;
               Position.Max := MMWaveMixer.BufferByName[aName].BufferLength div 100;
               Position.Position := MMWaveMixer.BufferByName[aName].Position div 100;
               Left := MainForm.Width;
               Visible := True;

               inc(NumWaves);
               if (NumWaves = MaxWaves) then Open1.Enabled := False;
               break;
            end;
         end;
      end;
      MMMemoryWave.Wave.FreeWave;
   end;
end;

{-- TMainForm -----------------------------------------------------------}
procedure TMainForm.OptionsClick(Sender: TObject);
var
   i: integer;

begin
   if (Options.ShowModal = mrOK) and
      (Options.Combobox1.ItemIndex <> MMWaveMixer.DeviceID) then
   begin
      {close all channels }
      for i := 0 to ComponentCount-1 do
      begin
         if (Components[i] is TPanel) then
            TPanel(Components[i]).Visible := False;
      end;
      { close the waveMixer }
      MMWaveMixer.Close;
      NumWaves := 0;
      Open1.Enabled := True;
      { set new deviceID }
      MMWaveMixer.DeviceID := Options.ComboBox1.ItemIndex;
      { re-Open the WaveMixer }
      MMWaveMixer.Open;
   end;
end;

{-- TMainForm -----------------------------------------------------------}
procedure TMainForm.btnPlayClick(Sender: TObject);
var
   aName: String;

begin
   with (Sender as TButton).Parent do
   begin
      aName := WavePanels[Tag].Name.Caption;
      MMWaveMixer.PlayBuffer(MMWaveMixer.BufferByName[aName]);
   end;
end;

{-- TMainForm -----------------------------------------------------------}
procedure TMainForm.btnPauseClick(Sender: TObject);
var
   aName: String;

begin
   with (Sender as TButton).Parent do
   begin
      aName := WavePanels[Tag].Name.Caption;
      MMWaveMixer.PauseBuffer(MMWaveMixer.BufferByName[aName]);
   end;
end;

{-- TMainForm -----------------------------------------------------------}
procedure TMainForm.btnStopClick(Sender: TObject);
var
   aName: String;

begin
   with (Sender as TButton).Parent do
   begin
      aName := WavePanels[Tag].Name.Caption;
      MMWaveMixer.StopBuffer(MMWaveMixer.BufferByName[aName]);
   end;
end;

{-- TMainForm -----------------------------------------------------------}
procedure TMainForm.btnDuplicateClick(Sender: TObject);
var
   i: integer;
   aName: String;

begin
   if (NumWaves = MaxWaves) then exit;

   with (Sender as TButton).Parent do
   begin
      aName := WavePanels[Tag].Name.Caption;
      MMWaveMixer.DuplicateBuffer(aName, MMWaveMixer.BufferByName[aName]);
   end;

   for i := 0 to ComponentCount-1 do
   begin
      if (Components[i] is TPanel) then
      with TPanel(Components[i]) do
      begin
         if not Visible then
         with WavePanels[Tag] do
         begin
            Name.Caption := aName;
            Muting.Checked := MMWaveMixer.BufferByName[aName].Muted;
            Looping.Checked := MMWaveMixer.BufferByName[aName].Looping;
            Volume.Position := (MMWaveMixer.BufferByName[aName].Volume div 10)+400;
            Frequency.Position := MMWaveMixer.BufferByName[aName].Frequency;
            Panning.Position := (MMWaveMixer.BufferByName[aName].Panning div 10)+400;
            Position.Max := MMWaveMixer.BufferByName[aName].BufferLength div 100;
            Position.Position := MMWaveMixer.BufferByName[aName].Position div 100;
            Left := MainForm.Width;
            Visible := True;

            inc(NumWaves);
            if (NumWaves = MaxWaves) then Open1.Enabled := False;
            break;
         end;
      end;
   end;
end;

{-- TMainForm -----------------------------------------------------------}
procedure TMainForm.btnCloseClick(Sender: TObject);
var
   aName: String;

begin
   with (Sender as TButton).Parent do
   begin
      aName := WavePanels[Tag].Name.Caption;
      MMWaveMixer.RemoveBuffer(MMWaveMixer.BufferByName[aName]);

      dec(NumWaves);
      if (NumWaves < MaxWaves) then Open1.Enabled := True;

      Visible := False;
   end;
end;

{-- TMainForm -----------------------------------------------------------}
procedure TMainForm.ckBLoopClick(Sender: TObject);
var
   aName: String;

begin
   with (Sender as TCheckBox).Parent do
   begin
      aName := WavePanels[Tag].Name.Caption;
      MMWaveMixer.BufferByName[aName].Looping := TCheckBox(Sender).Checked;
   end;
end;

{-- TMainForm -----------------------------------------------------------}
procedure TMainForm.ckBMuteClick(Sender: TObject);
var
   aName: String;

begin
   with (Sender as TCheckBox).Parent do
   begin
      aName := WavePanels[Tag].Name.Caption;
      MMWaveMixer.BufferByName[aName].Muted := TCheckBox(Sender).Checked;
   end;
end;

{-- TMainForm -----------------------------------------------------------}
procedure TMainForm.trackVolumeChange(Sender: TObject);
var
   aName: String;

begin
   with (Sender as TTrackBar).Parent do
   begin
      aName := WavePanels[Tag].Name.Caption;
      MMWaveMixer.BufferByName[aName].Volume := (TTrackBar(Sender).Position+(-400))*10;
   end;
end;

{-- TMainForm -----------------------------------------------------------}
procedure TMainForm.trackPanningChange(Sender: TObject);
var
   aName: String;

begin
   with (Sender as TTrackBar).Parent do
   begin
      aName := WavePanels[Tag].Name.Caption;
      MMWaveMixer.BufferByName[aName].Panning := (TTrackBar(Sender).Position+(-400))*10;
   end;
end;

{-- TMainForm -----------------------------------------------------------}
procedure TMainForm.trackFrequencyChange(Sender: TObject);
var
   aName: String;

begin
   with (Sender as TTrackBar).Parent do
   begin
      aName := WavePanels[Tag].Name.Caption;
      MMWaveMixer.BufferByName[aName].Frequency := TTrackBar(Sender).Position;
   end;
end;

{-- TMainForm -----------------------------------------------------------}
procedure TMainForm.MMHiTimerTimer(Sender: TObject);
var
   i: integer;
begin
    for i := 0 to ComponentCount-1 do
    begin
       if (Components[i] is TPanel) then
       with TPanel(Components[i]) do
       begin
          if Visible and (Tag > 0) then
          with WavePanels[Tag] do
               Position.Position := MMWaveMixer.BufferByName[Name.Caption].Position div 100;
       end;
    end;
end;

{-- TMainForm -----------------------------------------------------------}
procedure TMainForm.btnExitClick(Sender: TObject);
begin
   Close;
end;

end.
